def solve(n, a):
    # Перетворюємо числа на рядки і зберігаємо їх разом з індексами
    a = [(str(num), num) for num in a]
    
    # Сортуємо числа за рядковим представленням
    a.sort()

    # Підмножини, які будемо формувати
    subsets = []
    
    # Поточна підмножина
    current_subset = []
    
    # Перебираємо числа в порядку сортування
    for i in range(n):
        num_str = a[i][0]
        num = a[i][1]
        
        # Якщо поточне число є префіксом жодного з чисел в поточній підмножині
        # або це перше число в поточній підмножині, додаємо його
        if all(not num_str.startswith(str(x)) for x in current_subset):
            if current_subset:
                subsets.append(current_subset)
            current_subset = [num]
        else:
            current_subset.append(num)

    # Додаємо останню підмножину
    if current_subset:
        subsets.append(current_subset)
    
    # Виведення результату
    print(len(subsets))
    for subset in subsets:
        print(len(subset))
        print(" ".join(map(str, subset)))

# Вхідні дані
n = int(input())  # довжина масиву
a = list(map(int, input().split()))  # масив чисел

# Виведення результату
solve(n, a)